﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.WF
{
    public class ScheduledAdmissionMap : EntityMap<ScheduledAdmission>
    {
        public override string Location
        {
            get { return "DGS(41.1,"; }
        }

        public override ScheduledAdmission NewEntity(string ien)
        {
            return new ScheduledAdmission() { IEN = ien };
        }

        public override string File
        {
            get { return "41.1"; }
        }

        protected override void MapFields()
        {
            MapPointerToFile<Patient>(".01", (m, s) => m.PatientId = s, (m, s) => m.Patient = s);
            MapDateTime("2", (m, s) => m.ReservationDateTime = s);
            MapNumericInt("3", (m, s) => m.LengthOfStayExpected = s);
            MapFreeText("4", (m, s) => m.AdmittingDiagnosis = s);
            MapSetOfCodes("6", (m, s) => m.Surgery = s.ToString());
            MapPointerToFile<WardLocation>("8", (m, s) => m.WardLocationId = s, (m, s) => m.Ward = s);
            MapPointerToFile<FacilityTreatingSpecialty>("9", (m, s) => m.TreatingSpecialtyId = s, (m, s) => m.TreatingSpecialty = s);
            MapPointerToFile<MedicalCenterDivision>("12", (m, s) => m.MedicalCenterDivisionId = s, (m, s) => m.MedicalCenterDivision = s);
            MapDateTime("13", (m, s) => m.DateTimeCancelled = s);
            MapPointerToFile("14", (m, s) => m.CancelledById = s);
            MapPointerToFile<NewPerson>("5", (m, s) => m.ProviderId = s, (m, s) => m.Provider = s);
            MapPointerToFile<NewPerson>("11", (m, s) => m.SchedulerId = s, (m, s) => m.Scheduler = s);
            
        }
    }
}
